/*
* This file is part of Qccrypt, an open-source cross-platform frontend for ccrypt
* encryption tool.
* Copyright (C) 2006-2022  Philippe Beaureilles
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Philippe Beaureilles <qccrypt@free.fr>
* Program URL   : http://qccrypt.free.fr/
*
*/

#ifndef CCDLG_H
#define CCDLG_H

#include <QtGui>
#include <QProcess>
#include <QTabWidget>
#include <QCursor>
#include <QMessageBox>
#include <QDialog>
#include <QFileDialog>
#include <QInputDialog>
#include <QFileInfo>
#include <QDir>
#include <QString>
#include <QTabWidget>
#include <QListWidgetItem>
#include <QDropEvent>

#include "ui_ccryptdialog.h"

class QLabel;
class QLineEdit;

class CCryptDialog : public QDialog, private Ui::CCryptDialog
{
    Q_OBJECT

public:
    CCryptDialog(const QString &fileName, QString sessionPassword, QWidget *parent = 0);

private slots:
    void selectFileToEncrypt();
    void selectFileToDecrypt();
	void encryptFile();
	void decryptFile();
	void about();
	void showEncryptFileGroupBox();
	void showEncryptFolderGroupBox();
	void showDecryptFileGroupBox();
	void showDecryptFolderGroupBox();
	void encryptFolder();
	void decryptFolder();
    void selectFolderToEncrypt();
    void selectFolderToDecrypt();
    void determineAction(const QString &fileName);
    void clearProgressList();
    void exitQccrypt();
    void clickStayOnTopCheckbox();
    void clickKeepExistingFileDuringFileEncryptionCheckBox();
    void clickDoNotEncryptAlreadyEncryptedFilesDuringFolderEncryptionCheckBox();
    void clickKeepExistingEncryptedFileDuringFileDecryptionCheckBox();
    void clickTabQccryptMode(int tabIndex);

private:
    Ui_CCryptDialog ccdlg_ui;
    QSettings settings;
    QFileInfo currentFileToEncryptInfo;
    QFileInfo currentFileToDecryptInfo;
    QDir currentFolderToEncryptInfo;
    QDir currentFolderToDecryptInfo;
    qlonglong currentProgress;
    qlonglong subFilesCount;
    qlonglong alreadyEncryptedFilesCount;
    qlonglong successfullyEncryptedFilesCount;
    qlonglong fileEncryptionErrorCount;
    qlonglong successfullyDecryptedFilesCount;
    qlonglong fileDecryptionErrorCount;

	void updateFileToEncryptProperties();	
	void updateFileToDecryptProperties();	
	void updateFolderToEncryptProperties();	
	void updateFolderToDecryptProperties();	
	void emptyEncryptFileFields();
	void emptyEncryptFolderFields();
	void emptyDecryptFileFields();
    void emptyDecryptFolderFields();
	void emptyAllFields();
    int runFileEncryption(QString fileName, QString password, bool bEncryptAlreadyEncryptedFiles, bool bUseTemporaryFile, bool bUseKeyFile);
    int runFileDecryption(QString fileName, QString password, bool bUseTemporaryFile, bool bUseKeyFile);
    int runFolderEncryption(QString folderName, QString password, bool bUseTemporaryFile, bool bUseKeyFile);
    int runFolderDecryption(QString folderName, QString password, bool bUseTemporaryFile, bool bUseKeyFile);
    QString sessionPwd;
    QFileInfo sessionKeyFile; //Session Key File

	qlonglong getFolderSize(QString path);
    qlonglong getSubFoldersCount(QString path);
    qlonglong getSubFilesCount(QString path);

    QString getRandomString(int length);

protected:
    void dropEvent(QDropEvent *ev);
    void dragEnterEvent(QDragEnterEvent *ev);

};


#endif
