/*
* This file is part of Qccrypt, an open-source cross-platform frontend for ccrypt
* encryption tool.
* Copyright (C) 2006  Philippe Beaureilles
* This source code is based on a part of QPaMaT (password managing tool) source code
* developed by Bernhard Walle (<bernhard.walle@gmx.de>), and adapted to my needs, as it is
* permitted by the GNU GPL license.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Philippe Beaureilles <qccrypt@free.fr>
* Program URL   : http://qccrypt.free.fr/
*
*/
#ifndef NEWPASSWORDDIALOG_H
#define NEWPASSWORDDIALOG_H

#include <QDialog>
#include <QWidget>
#include <QLineEdit>
#include <QEvent>
#include <QString>
#include <QFocusEvent>
#include <QLayout>
#include <QLabel>
#include <QMessageBox>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QValidator>


class PasswordValidator : public QValidator
{
    public:
        PasswordValidator(QObject* parent = 0);
        State validate(QString& input, int& pos) const;
};

class NewPasswordDialog : public QDialog 
{
    Q_OBJECT
    
    public:
        NewPasswordDialog(QWidget* parent);
        QString getPassword() const;
        
    protected slots:
        void accept();
        
    private slots:
        void checkOkEnabled() const;
        void grabFirstPassword();
        void grabSecondPassword();
        void release();
        
    private:
        void createAndLayout();
        
    private:
        QPushButton*    m_okButton;
        QPushButton*    m_cancelButton;
        QLineEdit*  m_firstPasswordEdit;
        QLineEdit*  m_secondPasswordEdit;
};

#endif // NEWPASSWORDDIALOG_H
