/*
* This file is part of Qccrypt, an open-source cross-platform frontend for ccrypt
* encryption tool.
* Copyright (C) 2006  Philippe Beaureilles
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Philippe Beaureilles <qccrypt@free.fr>
* Program URL   : http://qccrypt.free.fr/
*
*/

#ifndef CCDLG_H
#define CCDLG_H

#include <QDialog>
#include <QFileInfo>
#include <QDir>
#include <QString>
#include <QTabWidget>
#include <QListWidgetItem>
#include <QDropEvent>

#include "ui_ccryptdialog.h"

class QLabel;
class QLineEdit;

class CCryptDialog : public QDialog, public Ui::CCryptDialog
{
    Q_OBJECT

public:
    CCryptDialog(const QString &fileName, QWidget *parent = 0);

private slots:
    void selectFileToEncrypt();
    void selectFileToDecrypt();
	void encryptFile();
	void decryptFile();
	void about();
	void showEncryptFileGroupBox();
	void showEncryptFolderGroupBox();
	void showDecryptFileGroupBox();
	void showDecryptFolderGroupBox();
	void encryptFolder();
	void decryptFolder();
    void selectFolderToEncrypt();
    void selectFolderToDecrypt();
    void determineAction(const QString &fileName);
    void clearProgressList();
    void exitQccrypt();
	
private:
    Ui_CCryptDialog ccdlg_ui;
    QFileInfo currentFileInfo;
	QDir currentFolderInfo;
    qlonglong currentProgress;
    qlonglong subFilesCount;

	void updateFileToEncryptProperties();	
	void updateFileToDecryptProperties();	
	void updateFolderToEncryptProperties();	
	void updateFolderToDecryptProperties();	
	void emptyEncryptFileFields();
	void emptyEncryptFolderFields();
	void emptyDecryptFileFields();
    void emptyDecryptFolderFields();
	void emptyAllFields();
    int runFileEncryption(QString fileName, QString password, QBool bEncryptAlreadyEncryptedFiles);
    int runFileDecryption(QString fileName, QString password);
    int runFolderEncryption(QString folderName, QString password);
    int runFolderDecryption(QString folderName, QString password);

	qlonglong getFolderSize(QString path);
    qlonglong getSubFoldersCount(QString path);
    qlonglong getSubFilesCount(QString path);

protected:
    void dropEvent(QDropEvent *ev);
    void dragEnterEvent(QDragEnterEvent *ev);

};


#endif
