/*
* This file is part of Qccrypt, an open-source cross-platform frontend for ccrypt
* encryption tool.
* Copyright (C) 2006  Philippe Beaureilles
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Philippe Beaureilles <qccrypt@free.fr>
* Program URL   : http://qccrypt.free.fr/
*
*/
#include <QApplication>
#include <QProcess>
#include <QMessageBox>
#include "ccdlg.h"

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	QString fileName;

	QString program = "ccrypt";
	QStringList arguments;
	arguments << "-V";

	QProcess *encryptProcess = new QProcess();
	encryptProcess->start(program, arguments);
	encryptProcess->waitForFinished();
	
	//Check if ccrypt tool is installed or not
	if (QString(encryptProcess->readAll()).isEmpty())
	{
		QMessageBox::information(0, "Qccrypt", "Ccrypt encryption/decryption tool not found!\nMake sure it's installed and accessible (check your PATH environement variable).", "&Ok");
		return 1;
	}
	else
	{
		if (argc >= 2)
			fileName = argv[1];
		else
			fileName = "";
	
		CCryptDialog ccdialog(fileName);
		return ccdialog.exec();
	}
}

