/*
* This file is part of Qccrypt, an open-source cross-platform frontend for ccrypt
* encryption tool.
* Copyright (C) 2006  Philippe Beaureilles
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail: Philippe Beaureilles <qccrypt@free.fr>
* Program URL   : http://qccrypt.free.fr/
*
*/

#ifndef TABDIALOG_H
#define TABDIALOG_H

#include <QDialog>
#include <QFileInfo>
#include <QString>
#include <QTabWidget>

#include "ui_ccryptdialog.h"

class QLabel;
class QLineEdit;

class CCryptDialog : public QDialog, public Ui::CCryptDialog
{
    Q_OBJECT

public:
    CCryptDialog(const QString &fileName, QWidget *parent = 0);

private slots:
    void setEncryptOpenFileName();
    void setDecryptOpenFileName();
	void encryptFile();
	void decryptFile();
	void about();
	
private:
    Ui_CCryptDialog ccdlg_ui;
	QFileInfo currentFileInfo;

	void emptyEncryptFileFields();
	void emptyDecryptFileFields();

};


#endif
